<?php	
	
	session_start();
	include('conexion.php');	
	require('./fpdf/fpdf.php');
	$_SESSION['tipo'] = 1;	
	$tarjeta = $_GET['tarjeta'];
	$fecha_inicio = $_GET['fecha_inicio'];
	$fecha_fin = $_GET['fecha_fin'];
	
	$pdf=new FPDF();
	$pdf->AliasNbPages();
	$pdf->SetTitle('Control de vehiculos');
	$pdf->AddPage();
	
	$pdf->SetFont('Arial','',10);
	$pdf->Ln();		
	$pdf->Cell(25,5,"Cliente");
	$pdf->Cell(50,5,$_SESSION["id_cliente"]);
	$pdf->Ln();		
	$pdf->Cell(25,5,"Razon Social");
	$pdf->Cell(50,5,$_SESSION['razon_social']);
	$pdf->Ln();		
	$pdf->Cell(25,5,"Saldo");
	$pdf->Cell(50,5,$_SESSION['saldo']);
	$pdf->Ln();
	$pdf->Cell(25,5,"Fecha Inicio");
	$pdf->Cell(50,5,$fecha_inicio);
	$pdf->Ln();		
	$pdf->Cell(25,5,"Fecha Fin");
	$pdf->Cell(50,5,$fecha_fin);
	$pdf->Ln();		
	$pdf->Ln();		
	
	$sql="select  ";
	$sql.="c.id_tag as tag, "; 
	$sql.="c.descripcion as descripcion, ";
	$sql.="a.placa as placa, ";
	$sql.="a.fecha as fecha, ";
	$sql.="a.odometro as odometro, ";
	$sql.="a.odometro_diferencia/b.volumen as rendimiento, ";
	$sql.="d.nombre as nombre, ";
	$sql.="format(b.precio,3) as precio, ";
	$sql.="format(b.volumen,3) as volumen, ";
	$sql.="format(b.monto,2) as monto ";
	$sql.="from ";
	$sql.="transacciones a, ";
	$sql.="transacciones_detalle b, ";
	$sql.="vehiculos c, ";
	$sql.="productos d ";
	$sql.="where ";
	$sql.="a.id_transaccion=b.id_transaccion and ";
	$sql.="a.id_vehiculo=c.id_vehiculo and ";
	$sql.="b.id_producto=d.id_producto and ";
	$sql.="a.id_cliente = ".$_SESSION['id_cliente']." and ";
	$sql.="a.fecha between '" . $fecha_inicio ."' and '" . $fecha_fin . "' ";
	
	if($tarjeta != 0)
		$sql.="and c.id_vehiculo = ".$tarjeta." ";
	
	$sql.="order by ";
	$sql.="a.id_tag, ";
	$sql.="a.id_transaccion ";
	
	$resultado = $iden->query($sql); 
	
	if(!$resultado) 
		die("Error: no se pudo realizar la consulta");
	
	$número_filas = $resultado->num_rows;
		
	if($número_filas > 0)
	{
		$pdf->SetFont('Arial','',7);
		$pdf->SetFillColor(128,128,128);
		
		$pdf->Cell(15,5,"Tarjeta",1,0,'L',true);	
		$pdf->Cell(32,5,"Descripcion",1,0,'L',true);	
		$pdf->Cell(17,5,"Placas",1,0,'L',true);	
		$pdf->Cell(30,5,"Fecha Hora",1,0,'L',true);	
		$pdf->Cell(15,5,"Kms",1,0,'R',true);	
		$pdf->Cell(17,5,"Rendiento",1,0,'R',true);	
		$pdf->Cell(25,5,"Producto",1,0,'L',true);	
		$pdf->Cell(15,5,"Precio",1,0,'R',true);	
		$pdf->Cell(15,5,"Litros",1,0,'R',true);	
		$pdf->Cell(15,5,"Importe",1,0,'R',true);	
		$pdf->Ln();		
		
		$tag_anterior = 0;
		$inicio = 0;	
		$sub_total_volumen = 0;
		$sub_total_monto = 0;
		$total_volumen = 0;
		$total_monto = 0;
		$pdf->SetFillColor(192,192,192);
		while($fila = $resultado->fetch_assoc()) 
		{
			if($inicio == 0)
			{
				$tag_anterior = $fila['tag'];
				$num_tarjetas = $num_tarjetas + 1;
			}
			if($tag_anterior == $fila['tag'])
			{
				$pdf->Cell(15,5,$fila["tag"],0,0,'L',false);	
				$pdf->Cell(32,5,$fila["descripcion"],0,0,'L',false);	
				$pdf->Cell(17,5,$fila["placa"],0,0,'L',false);	
				$pdf->Cell(30,5,$fila["fecha"],0,0,'L',false);	
				$pdf->Cell(15,5,$fila["odometro"],0,0,'R',false);	
				
				if($fila["rendimiento"]>=0)
					$pdf->Cell(17,5,number_format($fila["rendimiento"],3),0,0,'R',false);	
				else
					$pdf->Cell(17,5,number_format(0,3),0,0,'R',false);	
				
				$pdf->Cell(25,5,$fila["nombre"],0,0,'L',false);	
				$pdf->Cell(15,5,number_format($fila["precio"],3),0,0,'R',false);	
				$pdf->Cell(15,5,number_format($fila["volumen"],3),0,0,'R',false);	
				$pdf->Cell(15,5,number_format($fila["monto"],2),0,0,'R',false);	
				$pdf->Ln();						
				$sub_total_volumen=$sub_total_volumen+$fila["volumen"];
				$sub_total_monto=$sub_total_monto+$fila["monto"];
				
				$total_volumen=$total_volumen+$fila["volumen"];
				$total_monto=$total_monto+$fila["monto"];
			}else{
				$num_tarjetas = $num_tarjetas + 1;
				$pdf->Cell(15,5,"",0,0,'L',false);	
				$pdf->Cell(32,5,"",0,0,'L',false);	
				$pdf->Cell(17,5,"",0,0,'L',false);	
				$pdf->Cell(30,5,"",0,0,'L',false);	
				$pdf->Cell(15,5,"",0,0,'L',false);	
				$pdf->Cell(17,5,"",0,0,'L',false);	
				$pdf->Cell(25,5,"",0,0,'L',false);	
				$pdf->Cell(15,5,"Subtotal",0,0,'R',false);	
				$pdf->Cell(15,5,number_format($sub_total_volumen,3),0,0,'R',false);	
				$pdf->Cell(15,5,number_format($sub_total_monto,2),0,0,'R',false);	
				$pdf->Ln();						
				$sub_total_volumen=0;
				$sub_total_monto=0;
				$tag_anterior = $fila['tag'];
			}			
		}
		$resultado->free();
		$pdf->Cell(15,5,"",0,0,'L',false);	
		$pdf->Cell(32,5,"",0,0,'L',false);	
		$pdf->Cell(17,5,"",0,0,'L',false);	
		$pdf->Cell(30,5,"",0,0,'L',false);	
		$pdf->Cell(15,5,"",0,0,'L',false);	
		$pdf->Cell(17,5,"",0,0,'L',false);	
		$pdf->Cell(25,5,"",0,0,'L',false);	
		$pdf->Cell(15,5,"Subtotal",0,0,'R',false);	
		$pdf->Cell(15,5,number_format($sub_total_volumen,3),0,0,'R',false);	
		$pdf->Cell(15,5,number_format($sub_total_monto,2),0,0,'R',false);	
		$pdf->Ln();					
		$pdf->Cell(15,5,"Total tarjetas",0,0,'L',true);	
		$pdf->Cell(32,5,$num_tarjetas,0,0,'R',true);	
		$pdf->Cell(17,5,"",0,0,'L',true);	
		$pdf->Cell(30,5,"Total registros",0,0,'L',true);	
		$pdf->Cell(15,5,$número_filas,0,0,'R',true);	
		$pdf->Cell(17,5,"",0,0,'L',true);	
		$pdf->Cell(25,5,"",0,0,'L',true);	
		$pdf->Cell(15,5,"Total",0,0,'L',true);	
		$pdf->Cell(15,5,number_format($total_volumen,3),0,0,'R',true);	
		$pdf->Cell(15,5,number_format($total_monto,3),0,0,'R',true);	
		$pdf->Ln();			
	}		
	$pdf->Output();	
	mysqli_close($iden);
?>