<?php
	session_start();
	include('conexion.php');
	






	require('./fpdf/fpdf.php');
	class PDF extends FPDF
	{
		function Header()
		{	
			$this->SetFont('Arial','B',14);
			$this->Cell(145,10,'Adeudos de Cobro Antiguedad de Saldos');
			$this->SetFont('Arial','',10);
			date_default_timezone_set('America/Mexico_City');
			$time = time();	
			$this->Cell(50,10,'Fecha: ' . date("Y/m/d  H:i:s", $time) );
			$this->Ln();
			$this->Cell(50,5,$_SESSION['id_cliente']." ".$_SESSION['razon_social']);
			$this->Ln();
			$this->Cell(17,5,"Id",'B',0,'R');
			$this->Cell(10,5,"Serie",'B',0,'L');
			$this->Cell(19,5,"Folio",'B',0,'L');
			$this->Cell(15,5,"Vigente",'B',0,'C');
			$this->Cell(26,5,"15",'B',0,'R');
			$this->Cell(26,5,"30",'B',0,'R');
			$this->Cell(26,5,"60",'B',0,'R');
			$this->Cell(26,5,"90",'B',0,'R');	
			$this->Cell(26,5,"+90",'B',0,'R');
		
				
		}
	}

	$pdf=new PDF('P', 'mm', 'Letter');
	$pdf->SetAutoPageBreak(true,25); 
	$pdf->AliasNbPages();
	$pdf->SetTitle('Adeudos');
	$pdf->AddPage();
	$pdf->SetFont('Arial','',10);

 				$sql = "select  ";
                $sql .= "a.id_entidad id_entidad, ";
                $sql .= "b.rfc rfc, ";
                $sql .= "b.nombre_comercial nombre_comercial, ";
                $sql .= "a.id_adeudo id_adeudo, ";
                $sql .= "a.serie serie, ";
                $sql .= "a.folio folio, ";
                $sql .= "DATEDIFF(now(),vencimiento) 'Dias', ";
                $sql .= "if (DATEDIFF(now(),vencimiento) BETWEEN -999999999 and 0,a.saldo,0) as Vigente , ";
                $sql .= "if (DATEDIFF(now(),vencimiento) BETWEEN 1 and 15,a.saldo,0) as Quince, ";
                $sql .= "if (DATEDIFF(now(),vencimiento) BETWEEN 16 and 30,a.saldo,0) as Treinta, ";
                $sql .= "if (DATEDIFF(now(),vencimiento) BETWEEN 31 and 60,a.saldo,0) as Sesenta, ";
                $sql .= "if (DATEDIFF(now(),vencimiento) BETWEEN 61 and 90,a.saldo,0) as Noventa, ";
                $sql .= "if (DATEDIFF(now(),vencimiento)>90,a.saldo,0) as MasNoventa ";
                $sql .= "from adeudos_cobro a, clientes b ";
                $sql .= "where  ";
                $sql .= "a.id_entidad = b.id_cliente ";
                $sql .= "and round(a.saldo)<>0 ";
                $sql .= "and a.estatus<>3 ";
                $sql .= "and a.tipo_entidad=0  "; //clientes
                
                    $sql .= "and a.id_entidad =" .$_SESSION['id_cliente']. " ";
                $sql .= "order by ";
                $sql .= "a.id_entidad, a.id_adeudo ";

			$vigente=0;
			$quince=0;
			$treinta=0;
			$sesenta=0;
			$noventa=0;
			$masnoventa=0;
			mysqli_query($iden,'SET NAMES utf8');
			$resultado = $iden->query($sql); 
			while($fila = $resultado->fetch_assoc()) 
			{ 
				$pdf->Cell(17,5,$fila['id_entidad'],0,0,'R');
				$pdf->Cell(10,5,$fila['serie'],0,0,'L');
				$pdf->Cell(11,5,$fila['folio'],0,0,'R');
				$pdf->Cell(23,5,number_format($fila['Vigente'],2,'.',','),0,0,'R');
				$pdf->Cell(26,5,number_format($fila['Quince'],2,'.',','),0,0,'R');
				$pdf->Cell(26,5,number_format($fila['Treinta'],2,'.',','),0,0,'R');
				$pdf->Cell(26,5,number_format($fila['Sesenta'],2,'.',','),0,0,'R');
				$pdf->Cell(26,5,number_format($fila['Noventa'],2,'.',','),0,0,'R');	
				$pdf->Cell(26,5,number_format($fila['MasNoventa'],2,'.',','),0,0,'R');
				$pdf->Ln();
				
				$vigente+=$fila['Vigente'];
				$quince+=$fila['Quince'];
				$treinta+=$fila['Treinta'];
				$sesenta+=$fila['Sesenta'];
				$noventa+=$fila['Noventa'];
				$masnoventa+=$fila['MasNoventa'];
			}
			$pdf->Ln();
			$pdf->Cell(17,5,"",0,0,'R');
			$pdf->Cell(10,5,"",0,0,'L');
			$pdf->Cell(19,5,"",0,0,'L');
			$pdf->Cell(15,5,number_format($vigente,2,'.',','),0,0,'R');
			$pdf->Cell(26,5,number_format($quince,2,'.',','),0,0,'R');
			$pdf->Cell(26,5,number_format($treinta,2,'.',','),0,0,'R');
			$pdf->Cell(26,5,number_format($sesenta,2,'.',','),0,0,'R');
			$pdf->Cell(26,5,number_format($noventa,2,'.',','),0,0,'R');	
			$pdf->Cell(26,5,number_format($masnoventa,2,'.',','),0,0,'R');
			$pdf->Ln();
	$pdf->Output();
?>